#! /usr/bin/perl

#########################################################
#                                                       #
#  Voting Center Version: 1.0C (Beta)                   #
#  Letzte Modifikation: 11-05-97                        #
#  Geschrieben von: David Tsai                          #
#  http://www.web-consult.com                           #
#                                                       #
#########################################################
#                                                       #
#  Copyright  1997 David Tsai, Web Consultant.         #
#  Sie haben das Recht, dieses Script zu benutzen.	#
#  Es darf jedoch nicht ohne die schriftliche 		#
#  Genehmigung von David Tsai verkauft werden. 		#
#  Dieses Script darf auch nicht ohne die Zustimmung	#
#  des Autors modifiziert werden, esseidenn es handelt	#
#  sich dabei um eine modifikation der Variablen in 	#
#  der Datei config.cgi					#
#							#
#########################################################


require 'config.cgi';
&check_exp;
&parse_query;


#=============================================
#   H A U P T P R O G R A M M

if($QUERY{'action'} eq "") {

    print "Content-Type: text/html\n\n";
    print "<HTML>\n";
    print "<TITLE>$title</TITLE>\n";
    print "<BODY BGCOLOR=\"$bgcolor\" BACKGROUND=\"$background\" TEXT=\"$text_color\" LINK=\"$link_color\" ALINK=\"$link_color\" VLINK=\"$vlink_color\">\n";
    print "<CENTER>\n";
    if($heading =~ /.*\.(gif|jpg)/i) {
        print "<IMG SRC=\"$heading\" BORDER=0 ALT=\"$title\">\n";
    }
    else {
        print "<H1>$heading</H1>\n";
    }

    print "<TABLE BORDER=$table_border CELLSPACING=$cellspacing CELLPADDING=$cellpadding BGCOLOR=\"$table_color\">\n";
    print "<TR><TD><B><FONT SIZE=4 FACE=\"ARIAL\">Liste der derzeitigen Abstimmungen:</B> (Klicken Sie auf eine Abstimmung um selbst zu stimmen und den Stand einzusehen)</FONT></TR></TD>\n";

    opendir(VOTE, "$base_dir") || die "Can't open directory $base_dir\n";
    while($file = readdir(VOTE)) {
        if($file =~ /.*\.$file_ext/ && $file !~ /\.old/) {
            open(FILE, "$base_dir/$file") || die "Can't open $file\n";
            $data =<FILE>;
            close(FILE);

            $topic = $file;
            $topic =~ s/\..*//g;

            $data =~ s/\n//g;
            @pairs = split(/&/, $data);
            foreach $pair (@pairs) {
                ($name, $value) = split(/=/, $pair);
                if($name eq "question") {
                    $question = $value;
                }
                elsif($name eq "exp") {
                    $exp = $value;
                }
                else {
                    push(@ANSWERS, "$name");
                    $VOTE{$name} = $value;
                }
            }

            if(!($exp =~ /never/i)) {
                $exp -= &get_days;
                $exp = " in $exp Tag(en)";
            }

            print "<TR><TD><B><FONT SIZE=3 FACE=\"Arial\"><A HREF=\"$script_url?action=results&topic=$topic\">$question</A> &nbsp\;&nbsp\;-&nbsp\;&nbsp\; Ablauf: $exp</FONT></B></TR></TD>\n";
        }

    }

    closedir(VOTE);
    print "<TR><TD></TR></TD>\n";
    print "<TR><TD><B><FONT SIZE=4 FACE=\"Arial\">Abgelaufende Abstimmungen:</B> (Klicken Sie auf eine Abstimmung um die Ergebnisse einzusehen)</FONT></TR></TD>\n";

    opendir(VOTE, "$base_dir") || die "Can't open $base_dir\n";
    while($file = readdir(VOTE)) {

        if($file =~ /.*\.$file_ext\.old/) {
            open(FILE, "$base_dir/$file") || die "Can't open $file\n";
            $data =<FILE>;
            close(FILE);

            $topic = $file;
            $topic =~ s/\..*//g;

            $data =~ s/\n//g;
            @pairs = split(/&/, $data);
            foreach $pair (@pairs) {
                ($name, $value) = split(/=/, $pair);
                if($name eq "question") {
                    $question = $value;
                }
                elsif($name eq "exp") {
                    $exp = $value;
                }
                else {
                    push(@ANSWERS, "$name");
                    $VOTE{$name} = $value;
                }
            }
            print "<TR><TD><B><FONT SIZE=3 FACE=\"Arial\"><A HREF=\"$script_url?action=results&topic=$topic\">$question</A></FONT></B></TR></TD>\n";
        }
    }
    closedir(VOTE);


    print "</TABLE>\n";
    print "<FONT FACE=\"Arial\" SIZE=2>Dieses Script ist von: <A HREF=\"http://www.web-consult.com/paradise/\">CGI Paradise</A></FONT><br>\n";
    print "<FONT FACE=\"Arial\" SIZE=2>Ins Deutsche bersetzt von: <A HREF=\"http://www.tag4tag.comg/\">Tag -4- Tag</A></FONT>\n";

}

elsif($QUERY{'action'} eq "vote") {

    &parse_form;
    $topic = "$FORM{'topic'}";
    &error("Form Incomplete") unless $FORM{'vote'};
    &check('0');
    if($voted) {
        &error("Sie knnen nur einmal stimmen!  Sie haben fr dieses Thema schon vorher gestimmt.  Wenn Sie denken, dass dies ein Fehler ist, so wenden Sie sich bitte an den WebMaster.");
    }
    $database = "$base_dir/$topic\.$file_ext";

    open(FILE, "$database") || die "Can't open $data\n";
    $data =<FILE>;
    close(FILE);

    $data =~ s/\n//g;

    @pairs = split(/&/, $data);
    foreach $pair (@pairs) {
        ($name, $value) = split(/=/, $pair);
        push(@ANSWERS, "$name");
        $VOTE{$name} = $value;
    }

    $casted_vote = $FORM{'vote'};

    if((! $VOTE{$casted_vote}) && ($VOTE{$casted_vote} ne '0')) {
        &error("Vote field not found!");
    }

    $VOTE{$casted_vote}++;

    $flag = 0;

    foreach $vote (@ANSWERS) {
        if(! $flag) {
            $string = "$vote=$VOTE{$vote}";
            $flag = 1;
        }

        else {
            $string = "$string&$vote=$VOTE{$vote}";
        }
    }

    $string =~ s/\n//g;
    open(FILE, ">$database") || die "Can't open $database\n";
    print FILE "$string\n";
    close(FILE);
    &header("Ihr Stimme wurde gezhlt!  Die <A HREF=\"$script_url?action=results\&topic=$topic\">Abstimmungsergebnisse</A> wurden aktualisiert.");

}

elsif($QUERY{'action'} eq "results") {

    $topic = $QUERY{'topic'};
    &check('1');
    $database = "$base_dir/$QUERY{'topic'}.$file_ext";

    if(! -e $database) {
        $database = "$database.old";
        $voted = 5;
        if(! -e $database) {
            &error("Topic Not Found");
        }
    }

    open(FILE, "$database") || die "Can't open $database\n";
    $data =<FILE>;
    close(FILE);

    $data =~ s/\n//g;

    @pairs = split(/&/, $data);
    foreach $pair (@pairs) {
        ($name, $value) = split(/=/, $pair);
        if($name eq "question") {
            $question = $value;
        }
        elsif($name eq "exp") {
            $exp = $value;
        }
        else {
            push(@ANSWERS,"$name");
            $VOTE{$name} = $value;
        }
    }

    foreach $a (@ANSWERS) {
        $total += $VOTE{$a};
    }

    print "Content-Type: text/html\n\n";
    print "<TITLE>$title</TITLE>\n";
    print "<BODY BGCOLOR=\"$bgcolor\" BACKGROUND=\"$background\" TEXT=\"$text_color\" LINK=\"$link_color\" ALINK=\"$link_color\" VLINK=\"$vlink_color\">\n";
    print "<CENTER>\n";
    if($heading =~ /.*\.(gif|jpg)/i) {
        print "<IMG SRC=\"$heading\" BORDER=0 ALT=\"$title\">\n";
    }
    else {
        print "<H1>$heading</H1>\n";
    }
    print "<TABLE BGCOLOR=\"$table_color\" BORDER=$table_border CELLSPACING=$cellspacing CELLPADDING=$cellpadding>\n";
    if(!$voted) {
        print "<FORM ACTION=\"$script_url?action=vote\" METHOD=\"POST\">\n";
        print "<INPUT TYPE=\"HIDDEN\" NAME=\"topic\" VALUE=\"$QUERY{'topic'}\">\n";
    }

    print "<TR><TD COLSPAN=2><B><CENTER><FONT SIZE=2 FACE=\"Arial\"><A HREF=\"$site_url\">Zurck zu $sitename</A>\&nbsp\;\&nbsp\; | \&nbsp\;\&nbsp\;</FONT>\n";
    print "<FONT SIZE=2 FACE=\"Arial\"><A HREF=\"$script_url\">Zurck zur Abstimmungsliste</A></FONT></B></CENTER></TR>\n";
    print "<TR><TD COLSPAN=2><B><FONT SIZE=3 FACE=\"ARIAL\">$question &nbsp\;\[$total Stimmabgaben gesamt\]</FONT></B></TR></TD>\n";
    foreach $key (@ANSWERS) {
        if($total eq '0') {
            $percent = 0;
        }
        else {
            $percent = int($VOTE{$key} / $total * 100);
        }
        $width = $percent * $length;
        print "<TR><TD><B>\n";
        if(! $voted) {
            print "<INPUT TYPE=\"RADIO\" NAME=\"vote\" VALUE=\"$key\">\n";
        }
        print " $key</B></TD>\n";
        print "<TD ALIGN=\"left\"><IMG SRC=\"$image_file\" BORDER=0 WIDTH=$width HEIGHT=$height> <FONT SIZE=2 FACE=\"ARIAL\">$VOTE{$key}\($percent\%\)</FONT></TR></TD>\n";
    }
    print "<TR><TD><B>Status:</B></TD><TD>\n";
    if(! $voted) {
        print "<B><FONT FACE=\"ARIAL\" SIZE=2>Sie haben fr diese Abstimmung noch nicht gestimmt. </B></FONT><INPUT TYPE=\"SUBMIT\" VALUE=\"Stimme abgeben\"></CENTER>\n";
    }
    elsif($voted eq '5') {
        print "<B><FONT FACE=\"ARIAL\" SIZE=2>Diese Abstimmung ist abgelaufen</B></FONT>\n";
    }
    else {
        print "<B><FONT FACE=\"ARIAL\" SIZE=2>Sie haben fr diese Abstimmung schon Ihre Stimme abgegeben.</FONT></B>\n";
    }
    print "</TR></TD></FORM></TABLE>\n";
    print "<FONT SIZE=2 FACE=\"Arial\">Das Script ist von: <A HREF=\"http://www.web-consult.com/paradise/\">CGI Paradise</A></FONT><P>\n";
    print "<FONT FACE=\"Arial\" SIZE=2>Ins Deutsche bersetzt von: <A HREF=\"http://www.tag4tag.com/\">Tag -4- Tag</A></FONT>\n";

}


else {
    &error("Das Kommando, welches Sie im Script spezifiziert haben wurde nicht gefunden.
    Entweder handelt es sich hierbei um eine Fehlkonfiguration des Scripts oder einem Bug im Script.
    Es kann auch ein Fehler des Users sein.");
}



#===========================================
#  S U B   R O U T I N E S

sub check {

    local($flag) = @_;
    if($check >= 1 && $check ne '2') {
        $hostname = $ENV{'REMOTE_HOST'};
        if ($ENV{'REMOTE_HOST'} && ($ENV{'REMOTE_HOST'} !~ /^[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+$/)) {
            $hostname = $ENV{'REMOTE_HOST'};
        }
        else {
            &address_to_name ($ENV{'REMOTE_ADDR'});
        }

        $ip_file = "$base_dir/$topic\.ip";
        open(FILE, "$ip_file") || die "Can't open $ip_file\n";
        @lines =<FILE>;
        close(FILE);

        $vote = 0;
        foreach $line (@lines) {
            $line =~ s/\n//g;
            if($line =~ /$hostname/i) {
                $voted = 1;
            }
        }

        if((! $voted) && (! $flag)) {
            open(FILE, ">>$ip_file") || die "Can't open $ip_file\n";
            print FILE "$hostname\n";
            close(FILE);
        }
    }
}


sub address_to_name {
    local ($address) = shift(@_);
    local (@octets);
    local ($name, $aliases, $type, $len, $addr);
    local ($ip_number);
    @octets = split ('\.', $address);
    $ip_number = pack ("CCCC", @octets[0..3]);
    ($name, $aliases, $type, $len, $addr) = gethostbyaddr ($ip_number, 2);
    if ($name) {
        $hostname = $name;
    }
    else {
        $hostname = $ENV{'REMOTE_ADDR'};
    }
}


#  E N D   O F   S U B   R O U T I N E S
#===========================================





